#!/bin/bash
# CommStat macOS Installation Script

set -e  # Exit on error

echo "=============================================="
echo "CommStat macOS Installer"
echo "=============================================="

# Check if running on macOS
if [[ "$OSTYPE" != "darwin"* ]]; then
    echo "Error: This script is for macOS only."
    echo "For Linux, run: ./linuxinstall.sh"
    exit 1
fi

# Check for Homebrew
if ! command -v brew &> /dev/null; then
    echo "Error: Homebrew not found."
    echo ""
    echo "Install Homebrew first:"
    echo '  /bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"'
    echo ""
    echo "Then run this script again."
    exit 1
fi

# Check for Python 3
if ! command -v python3 &> /dev/null; then
    echo "Python 3 not found. Installing via Homebrew..."
    brew install python3
fi

echo ""
echo "Installing Enchant via Homebrew..."
echo ""

brew install enchant

echo ""
echo "Running Python installer..."
echo ""

python3 install.py

# Create launcher script for macOS
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
cat > "$SCRIPT_DIR/run_commstat.sh" << 'EOF'
#!/bin/bash
# CommStat macOS Launcher
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
exec python3 "$SCRIPT_DIR/commstat.py" "$@"
EOF
chmod +x "$SCRIPT_DIR/run_commstat.sh"

echo ""
echo "=============================================="
echo "Installation complete!"
echo "https://commstat-improved.com/"
echo "=============================================="
